<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The incentive details.
 */
class IncentiveInformation implements \JsonSerializable
{
    /**
     * @var IncentiveDetails[]|null
     */
    private $incentiveDetails;

    /**
     * Returns Incentive Details.
     * An array of incentive details.
     *
     * @return IncentiveDetails[]|null
     */
    public function getIncentiveDetails(): ?array
    {
        return $this->incentiveDetails;
    }

    /**
     * Sets Incentive Details.
     * An array of incentive details.
     *
     * @maps incentive_details
     *
     * @param IncentiveDetails[]|null $incentiveDetails
     */
    public function setIncentiveDetails(?array $incentiveDetails): void
    {
        $this->incentiveDetails = $incentiveDetails;
    }

    /**
     * Converts the IncentiveInformation object to a human-readable string representation.
     *
     * @return string The string representation of the IncentiveInformation object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('IncentiveInformation', ['incentiveDetails' => $this->incentiveDetails]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->incentiveDetails)) {
            $json['incentive_details'] = $this->incentiveDetails;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
